document.addEventListener("DOMContentLoaded", () => {
    const deleteLinks = document.querySelectorAll("a.delete-link");

    deleteLinks.forEach(link => {
        link.addEventListener("click", (e) => {
            const confirmDelete = confirm("Yakin ingin menghapus data ini?");
            if (!confirmDelete) {
                e.preventDefault();
            }
        });
    });

    const formElements = document.querySelectorAll("form input, form select, form textarea");
    formElements.forEach(input => {
        input.addEventListener("invalid", (e) => {
            e.target.classList.add("error");
        });
        input.addEventListener("input", (e) => {
            e.target.classList.remove("error");
        });
    });
    
});

