<?php
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Koneksi ke database
$mysqli = new mysqli("localhost", "root", "", "persewaan_db");

if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil ID dari URL
$id = isset($_GET['id']) ? $_GET['id'] : null;
if ($id) {
    // Ambil data kendaraan berdasarkan ID
    $stmt = $mysqli->prepare("SELECT * FROM persewaan_kendaraan WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Proses pembaruan
        $plat_nomor = $_POST['plat_nomor'];
        $jenis_kendaraan = $_POST['jenis_kendaraan'];
        $harga_sewa = $_POST['harga_sewa'];
        $durasi = $_POST['durasi'];
    
        $update_stmt = $mysqli->prepare("UPDATE persewaan_kendaraan SET plat_nomor = ?, jenis_kendaraan = ?, harga_sewa = ?, durasi = ? WHERE id = ?");
        $update_stmt->bind_param("ssisi", $plat_nomor, $jenis_kendaraan, $harga_sewa, $durasi, $id);
    
        if ($update_stmt->execute()) {
            $message = "Data berhasil diperbarui.";
        } else {
            $message = "Terjadi kesalahan: " . $update_stmt->error;
        }
    
        $update_stmt->close();
    }
    

    $stmt->close();
} else {
    echo "Data tidak ditemukan.";
}

$mysqli->close();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Data Persewaan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>Data Persewaan Kendaraan</h1>
            <nav>
                <a href="index.php">Beranda</a>
                <a href="create.php">Tambah Data</a>
                <a href="profile.php">Profil Usaha</a>
            </nav>
        </div>
    </header>

    <main>
        <div class="form-container">
            <h2>Edit Data Persewaan</h2>
            <form method="POST">
                <div class="form-group">
                    <label for="plat_nomor">Plat Nomor:</label>
                    <input type="text" name="plat_nomor" id="plat_nomor" value="<?= htmlspecialchars($data['plat_nomor']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="jenis_kendaraan">Jenis Kendaraan:</label>
                    <select name="jenis_kendaraan" id="jenis_kendaraan" required>
                        <option value="Motor" <?= $data['jenis_kendaraan'] == 'Motor' ? 'selected' : ''; ?>>Motor</option>
                        <option value="Mobil" <?= $data['jenis_kendaraan'] == 'Mobil' ? 'selected' : ''; ?>>Mobil</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="harga_sewa">Harga Sewa:</label>
                    <select name="harga_sewa" id="harga_sewa" required>
                        <option value="50000" <?= $data['harga_sewa'] == 50000 ? 'selected' : ''; ?>>Rp 50.000</option>
                        <option value="100000" <?= $data['harga_sewa'] == 100000 ? 'selected' : ''; ?>>Rp 100.000</option>
                        <option value="150000" <?= $data['harga_sewa'] == 150000 ? 'selected' : ''; ?>>Rp 150.000</option>
                        <option value="500000" <?= $data['harga_sewa'] == 500000 ? 'selected' : ''; ?>>Rp 500.000</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="durasi">Durasi:</label>
                    <input type="number" name="durasi" id="durasi" value="<?= htmlspecialchars($data['durasi']); ?>" required min="1">
                </div>
                <button type="submit" class="btn-submit">Simpan</button>
                <?php if (isset($message)) { ?>
                    <div class="message"><?= htmlspecialchars($message); ?></div>
                <?php } ?>

            </form>
        </div>
    </main>
</body>
</html>
