<?php
$mysqli = new mysqli("localhost", "root", "", "persewaan_db");

if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plat_nomor = $_POST['plat_nomor'];
    $jenis_kendaraan = $_POST['jenis_kendaraan'];
    $harga_sewa = $_POST['harga_sewa'];
    $durasi = $_POST['durasi'];

    $stmt = $mysqli->prepare("INSERT INTO persewaan_kendaraan (plat_nomor, jenis_kendaraan, harga_sewa, durasi) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssis", $plat_nomor, $jenis_kendaraan, $harga_sewa, $durasi);

    if ($stmt->execute()) {
        header("Location: index.php");
    } else {
        echo "Terjadi kesalahan: " . $stmt->error;
    }

    $stmt->close();
}

$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Tambah Data Persewaan</title>
        <link rel="stylesheet" href="style.css">
    </head>
    <body>
        <header>
            <div class="container">
                <h1>Data Persewaan Kendaraan</h1>
                <nav>
                    <a href="index.php">Beranda</a>
                    <a href="create.php">Tambah Data</a>
                    <a href="profile.php">Profil Usaha</a>
                </nav>
            </div>
        </header>

            <main>
                <div class="form-container">
                    <h2>Tambah Data Persewaan</h2>
                    <form method="POST">
                        <div class="form-group">
                            <label for="plat_nomor">Plat Nomor:</label>
                            <input type="text" name="plat_nomor" id="plat_nomor" required>
                        </div>
                        <div class="form-group">
                            <label for="jenis_kendaraan">Jenis Kendaraan:</label>
                            <select name="jenis_kendaraan" id="jenis_kendaraan" required>
                                <option value="Motor">Motor</option>
                                <option value="Mobil">Mobil</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="harga_sewa">Harga Sewa:</label>
                            <select name="harga_sewa" id="harga_sewa" required>
                                <option value="50000">Rp 50.000</option>
                                <option value="100000">Rp 100.000</option>
                                <option value="150000">Rp 150.000</option>
                                <option value="500000">Rp 500.000</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="durasi">Durasi:</label>
                            <input type="number" name="durasi" id="durasi" required min="1">
                        </div>
                        <button type="submit" class="btn-submit">Simpan</button>
                    </form>
                </div>
            </main>



            <footer>
                <p>&copy; 2024 Data Persewaan Kendaraan.Qian.</p>
            </footer>
    </body>
</html>
